
// Copyright  2000-2010 Luigi Pino. All Rights Reserved.

/***************************************************************************/

#include "../neurosis/neurosis.h"
#include "extra.h"
#include "render.h"

/***************************************************************************/

extern bool				gKicking;
extern bool				gMoving;
extern bool				gScrollMenu;
extern bool				gShowMenu;
extern bool				gWalking;
extern float			gDirection;
extern float			gMonsterMovement;
extern float			gPositionMonsters;
extern float			gPositionMoon;
extern float			gPositionPerson;
extern float			gPositionScenery;
extern float			gPositionTombstones;
extern float			gScroll;
extern float			gTimerKicking;
extern float			gTimerWalking;
extern float2			gPictureAdjustment;
extern float3			gRain[];
extern CTiming		gTiming;
extern CWindow		gWindow;
extern SMonster		gMonster[];
extern STombstone	gTombstone[];
extern int				gKickingFrame;
extern int				gWalkingFrame;

/***************************************************************************/

void Render_Game()

{
	// Clear buffer
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glClearColor(0.4392f, 0.4392f, 0.4392f, 1.0f);

	// Initialize viewpoint
	glLoadIdentity();
	glTranslatef(0.0f, 0.0f, -5.0f);

	Render_Moon();
	Render_Scenery();
	Render_Tombstones();

	// Will draw proper frame
	if (gMoving == true)
	{
		if (gKicking == true)
		{
			Render_Person_Kicking(gKickingFrame);

			if (gTimerKicking > 0.025f)
			{
				gKickingFrame = gKickingFrame + 1;
				gTimerKicking = 0.0f;
			}
			else
				gTimerKicking = gTimerKicking + gTiming.mInterval;

			if (gKickingFrame > 11)
			{
				gKickingFrame = 1;

						 if (gPositionPerson <= gMonster[2].hitPoint)			gMonster[2].hit = true;
				else if (gPositionPerson <= gMonster[1].hitPoint)			gMonster[1].hit = true;
				else if (gPositionPerson <= gMonster[0].hitPoint)			gMonster[0].hit = true;
			}
		}
		else if (gWalking == true)
		{
			Render_Person_Walking(gWalkingFrame);

			gPositionPerson = gPositionPerson - (gDirection * 15.0f * gTiming.mInterval);
			Clamp(&gPositionPerson, -32.0f, 7.0f, false);

			// Check for collision with monster
			bool collision = false;
			for (int x1=0;x1<3;x1=x1+1)
			{
				if ((gMonster[x1].dead == false) && (gPositionPerson < gMonster[x1].hitPoint))
				{
					gPositionPerson = gMonster[x1].hitPoint;
					collision = true;
				}
			}

			// Update camera position
			if (collision == false)
			{
				if ((gPositionPerson <= 5.0f) && (gPositionPerson >= -30.0f))
				{
					gPositionMoon = gPositionMoon - (gDirection * 0.5f * gTiming.mInterval);
					gPositionMonsters = gPositionMonsters - (gDirection * 15.0f * gTiming.mInterval);
					gPositionScenery = gPositionScenery - (gDirection * 2.0f * gTiming.mInterval);
					gPositionTombstones = gPositionTombstones - (gDirection * 4.0f * gTiming.mInterval);
				}

				if (gTimerWalking > 0.0025f)
				{
					gWalkingFrame = gWalkingFrame + 1;
					gTimerWalking = 0.0f;
				}
				else
					gTimerWalking = gTimerWalking + gTiming.mInterval;

				if (gWalkingFrame > 14)
					gWalkingFrame = 1;
			}
		}
	}
	else
	{
		if (gKicking == true)
			Render_Person_Kicking(gKickingFrame);
		else if (gWalking == true)
			Render_Person_Walking(gWalkingFrame);
	}

	// Makes monsters change frames
	if (gMonsterMovement <= 50.0f)
	{
		Render_Monster_1(1);
		Render_Monster_2(1);
		Render_Monster_3(1);
	}
	else
	{
		Render_Monster_1(2);
		Render_Monster_2(2);
		Render_Monster_3(2);
	}

	// Reinitialize viewpoint
	glLoadIdentity();
	glTranslatef(0.0f, 0.0f, -5.0f);

	// Draw rain and bottom floor
	Render_Rain();
	Render_Quad(-1, 1.0f, 1.0f, 1.0f, 0.0f, -2.5f, -1.7f, 1.0f, 2.5f, -1.7f, 1.0f, 2.5f, -1.4f, 1.0f, -2.5f, -1.4f, 1.0f);

	// Draws title screen
	if (gShowMenu == true)
	{
		glBindTexture(GL_TEXTURE_2D, gWindow.Texture_Get_Data(TEXTURE_TITLE_1));
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f, 0.0f);		glVertex3f(-7.3f + gScroll, -1.7f, 1.0f);
			glTexCoord2f(0.1f, 0.0f);		glVertex3f(-2.7f + gScroll, -1.7f, 1.0f);
			glTexCoord2f(0.1f, 0.07f);	glVertex3f(-2.7f + gScroll, 1.7f, 1.0f);
			glTexCoord2f(0.0f, 0.07f);	glVertex3f(-7.3f + gScroll, 1.7f, 1.0f);
		glEnd();

		glBindTexture(GL_TEXTURE_2D, gWindow.Texture_Get_Data(TEXTURE_TITLE_1));
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f, 0.05f);	glVertex3f(-6.7f + gScroll, -0.8f, 1.0f);
			glTexCoord2f(1.0f, 0.05f);	glVertex3f(-4.7f + gScroll, -0.8f, 1.0f);
			glTexCoord2f(1.0f, 0.95f);	glVertex3f(-4.7f + gScroll, 1.2f, 1.0f);
			glTexCoord2f(0.0f, 0.95f);	glVertex3f(-6.7f + gScroll, 1.2f, 1.0f);
		glEnd();

		glBindTexture(GL_TEXTURE_2D, gWindow.Texture_Get_Data(TEXTURE_TITLE_2));
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f, 0.0f);	glVertex3f(-4.7f + gScroll, -1.0f, 1.0f);
			glTexCoord2f(1.0f, 0.0f);	glVertex3f(-3.2f + gScroll, -1.0f, 1.0f);
			glTexCoord2f(1.0f, 1.0f);	glVertex3f(-3.2f + gScroll, 1.0f, 1.0f);
			glTexCoord2f(0.0f, 1.0f);	glVertex3f(-4.7f + gScroll, 1.0f, 1.0f);
		glEnd();
	}

	// Tells title screen to scroll
	if (gScrollMenu == true)
	{
		gScroll = gScroll - (3.0f * gTiming.mInterval);
		gMoving = true;
		gKicking = false;
		gWalking = true;
	}

	// Once past left side - stop drawing title screen
	if (gScroll < 0.0f)
	{
		gScrollMenu = false;
		gShowMenu = false;
	}

	// On-screen information
	#ifdef _DEBUG
		if (gShowMenu == false)
		{
			glDisable(GL_DEPTH_TEST);
			gWindow.Font_Begin(TEXTURE_FONT);
			gWindow.Font_List_Print(1.0f, 5.0f, 2.0f, 0.0f, 0.0f, 0.0f, false, false, "FPS: %.2f", 1.0f / gTiming.mInterval);
			gWindow.Font_List_Print(1.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f, false, false, "Position: %.2f", gPositionPerson);
			gWindow.Font_End();
			glEnable(GL_DEPTH_TEST);
		}
	#endif
}

/***************************************************************************/

void Render_Monster_1(int iFrame)

{
	if (iFrame == 1)
		gPictureAdjustment.x = 0.0f;
	else if (iFrame == 2)
		gPictureAdjustment.x = 0.5f;

	Render_Quad(TEXTURE_MONSTER_1, 1.0f, 1.0f, 1.0f, 0.0f, gPositionMonsters + gMonster[0].position, -1.45f, 1.0f, gPositionMonsters + gMonster[0].position + 0.5f, -1.45f, 1.0f, gPositionMonsters + gMonster[0].position + 0.5f, gMonster[0].top, 1.0f, gPositionMonsters + gMonster[0].position, gMonster[0].top, 1.0f, gPictureAdjustment.x, 0.0f, gPictureAdjustment.x + 0.5f, 0.0f, gPictureAdjustment.x + 0.5f, 1.0f, gPictureAdjustment.x, 1.0f);
}

/***************************************************************************/

void Render_Monster_2(int iFrame)

{
	if (iFrame == 1)
		gPictureAdjustment.x = 0.0f;
	else if (iFrame == 2)
		gPictureAdjustment.x = 0.5f;

	Render_Quad(TEXTURE_MONSTER_2, 1.0f, 1.0f, 1.0f, 0.0f, gPositionMonsters + gMonster[1].position, -1.5f, 1.0f, gPositionMonsters + gMonster[1].position - 1.0f, -1.5f, 1.0f, gPositionMonsters + gMonster[1].position - 1.0f, gMonster[1].top, 1.0f, gPositionMonsters + gMonster[1].position, gMonster[1].top, 1.0f, gPictureAdjustment.x, 0.0f, gPictureAdjustment.x + 0.5f, 0.0f, gPictureAdjustment.x + 0.5f, 1.0f, gPictureAdjustment.x, 1.0f);
}

/***************************************************************************/

void Render_Monster_3(int iFrame)

{
	if (iFrame == 1)
		gPictureAdjustment.y = 0.0f;
	else if (iFrame == 2)
		gPictureAdjustment.y = 0.5f;

	Render_Quad(TEXTURE_MONSTER_3, 1.0f, 1.0f, 1.0f, 0.0f, gPositionMonsters + gMonster[2].position, -1.5f, 1.0f, gPositionMonsters + gMonster[2].position - 2.0f, -1.5f, 1.0f, gPositionMonsters + gMonster[2].position - 2.0f, gMonster[2].top, 1.0f, gPositionMonsters + gMonster[2].position, gMonster[2].top, 1.0f, 0.0f, gPictureAdjustment.y, 1.0f, gPictureAdjustment.y, 1.0f, gPictureAdjustment.y + 0.5f, 0.0f, gPictureAdjustment.y + 0.5f);
}

/***************************************************************************/

void Render_Moon()

{
	Render_Quad(TEXTURE_MOON, 1.0f, 1.0f, 1.0f, 0.0f, gPositionMoon, 0.5f, 1.0f, gPositionMoon + 0.5f, 0.5f, 1.0f, gPositionMoon + 0.5f, 1.0f, 1.0f, gPositionMoon, 1.0f, 1.0f);
}

/***************************************************************************/

void Render_Person_Kicking(int iFrame)

{
			 if (iFrame == 1)		{ gPictureAdjustment.x = 0.00f;			gPictureAdjustment.y = 0.5f; }
	else if (iFrame == 2)		{ gPictureAdjustment.x = 0.33f;			gPictureAdjustment.y = 0.5f; }
	else if (iFrame == 3)		{ gPictureAdjustment.x = 0.66f;			gPictureAdjustment.y = 0.5f; }
	else if (iFrame == 4)		{ gPictureAdjustment.x = 0.00f;			gPictureAdjustment.y = 0.0f; }
	else if (iFrame == 5)		{ gPictureAdjustment.x = 0.33f;			gPictureAdjustment.y = 0.0f; }
	else if (iFrame == 6)		{ gPictureAdjustment.x = 0.66f;			gPictureAdjustment.y = 0.0f; }
	else if (iFrame == 7)		{ gPictureAdjustment.x = 0.33f;			gPictureAdjustment.y = 0.0f; }
	else if (iFrame == 8)		{ gPictureAdjustment.x = 0.00f;			gPictureAdjustment.y = 0.0f; }
	else if (iFrame == 9)		{ gPictureAdjustment.x = 0.66f;			gPictureAdjustment.y = 0.5f; }
	else if (iFrame == 10)	{ gPictureAdjustment.x = 0.33f;			gPictureAdjustment.y = 0.5f; }
	else if (iFrame == 11)	{ gPictureAdjustment.x = 0.00f;			gPictureAdjustment.y = 0.5f; }

	float position = 0.0f;
	if (gPositionPerson > 5.0f)
		position = gPositionPerson - 5.0f;
	else if (gPositionPerson < -30.0f)
		position = gPositionPerson + 30.0f;

	Render_Quad(TEXTURE_PERSON_KICK, 1.0f, 1.0f, 1.0f, 0.0f, (gDirection * -0.35f) - position, -1.4f, 1.0f, (gDirection * 0.35f) - position, -1.4f, 1.0f, (gDirection * 0.35f) - position, 0.0f, 1.0f, (gDirection * -0.35f) - position, 0.0f, 1.0f, gPictureAdjustment.x, gPictureAdjustment.y, gPictureAdjustment.x + 0.33f, gPictureAdjustment.y, gPictureAdjustment.x + 0.33f, gPictureAdjustment.y + 0.5f, gPictureAdjustment.x, gPictureAdjustment.y + 0.5f);
}

/***************************************************************************/

void Render_Person_Walking(int iFrame)

{
			 if (iFrame == 1)		{ gPictureAdjustment.x = 0.00f;			gPictureAdjustment.y = 0.5f; }
	else if (iFrame == 2)		{ gPictureAdjustment.x = 0.25f;			gPictureAdjustment.y = 0.5f; }
	else if (iFrame == 3)		{ gPictureAdjustment.x = 0.50f;			gPictureAdjustment.y = 0.5f; }
	else if (iFrame == 4)		{ gPictureAdjustment.x = 0.75f;			gPictureAdjustment.y = 0.5f; }
	else if (iFrame == 5)		{ gPictureAdjustment.x = 0.00f;			gPictureAdjustment.y = 0.0f; }
	else if (iFrame == 6)		{ gPictureAdjustment.x = 0.25f;			gPictureAdjustment.y = 0.0f; }
	else if (iFrame == 7)		{ gPictureAdjustment.x = 0.50f;			gPictureAdjustment.y = 0.0f; }
	else if (iFrame == 8)		{ gPictureAdjustment.x = 0.75f;			gPictureAdjustment.y = 0.0f; }
	else if (iFrame == 9)		{ gPictureAdjustment.x = 0.50f;			gPictureAdjustment.y = 0.0f; }
	else if (iFrame == 10)	{ gPictureAdjustment.x = 0.25f;			gPictureAdjustment.y = 0.0f; }
	else if (iFrame == 11)	{ gPictureAdjustment.x = 0.00f;			gPictureAdjustment.y = 0.0f; }
	else if (iFrame == 12)	{ gPictureAdjustment.x = 0.75f;			gPictureAdjustment.y = 0.5f; }
	else if (iFrame == 13)	{ gPictureAdjustment.x = 0.50f;			gPictureAdjustment.y = 0.5f; }
	else if (iFrame == 14)	{ gPictureAdjustment.x = 0.25f;			gPictureAdjustment.y = 0.5f; }

	float position = 0.0f;
	if (gPositionPerson > 5.0f)
		position = gPositionPerson - 5.0f;
	else if (gPositionPerson < -30.0f)
		position = gPositionPerson + 30.0f;

	Render_Quad(TEXTURE_PERSON_WALK, 1.0f, 1.0f, 1.0f, 0.0f, (gDirection * -0.35f) - position, -1.4f, 1.0f, (gDirection * 0.35f) - position, -1.4f, 1.0f, (gDirection * 0.35f) - position, 0.0f, 1.0f, (gDirection * -0.35f) - position, 0.0f, 1.0f, gPictureAdjustment.x, gPictureAdjustment.y, gPictureAdjustment.x + 0.25f, gPictureAdjustment.y, gPictureAdjustment.x + 0.25f, gPictureAdjustment.y + 0.5f, gPictureAdjustment.x, gPictureAdjustment.y + 0.5f);
}

/***************************************************************************/

void Render_Rain()

{
	int x1;

	// Update rain position
	for (x1=0;x1<RAIN_TOTAL;x1=x1+1)
	{
		// Reinitialize rain when it hits the ground
		if (gRain[x1].y < -1.75f)
		{
			gRain[x1].x = (float)(Calculate_Random(RAIN_AREA * 2 * 100)) / 100.0f - (float)(RAIN_AREA);
			gRain[x1].y = (float)(RAIN_HEIGHT);
		}
		else
			gRain[x1].y = gRain[x1].y - (gRain[x1].z * gTiming.mInterval);
	}

	// Draw first rain to make sure texture use changed correctly
	Render_Triangle(TEXTURE_RAIN, 0.5f, 1.0f, 1.0f, 0.0f, gRain[0].x - RAIN_SIZE, gRain[0].y - RAIN_SIZE, 1.0f, gRain[0].x + RAIN_SIZE, gRain[0].y + RAIN_SIZE, 1.0f, gRain[0].x - RAIN_SIZE, gRain[0].y + RAIN_SIZE, 1.0f);

	// Initialize OpenGL
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glColor4f(0.5f, 1.0f, 1.0f, 1.0f);

	// Draw rain
	glBegin(GL_TRIANGLES);
	for (x1=1;x1<RAIN_TOTAL;x1=x1+1)
	{
		glTexCoord2f(0.0f, 0.0f);			glVertex3f(gRain[x1].x - RAIN_SIZE, gRain[x1].y - RAIN_SIZE, 1.0f);
		glTexCoord2f(1.0f, 1.0f);			glVertex3f(gRain[x1].x + RAIN_SIZE, gRain[x1].y + RAIN_SIZE, 1.0f);
		glTexCoord2f(0.0f, 1.0f);			glVertex3f(gRain[x1].x - RAIN_SIZE, gRain[x1].y + RAIN_SIZE, 1.0f);
	}
	glEnd();
	glDisable(GL_BLEND);
	glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
}

/***************************************************************************/

void Render_Scenery()

{
	for (int x1=0;x1<10;x1=x1+1)
	{
		Render_Quad(TEXTURE_SCENERY, 1.0f, 1.0f, 1.0f, 0.0f, gPositionScenery - 2.0f + x1, -0.2f, 1.0f, gPositionScenery - 1.5f + x1, -0.2f, 1.0f, gPositionScenery - 1.5f + x1, 0.3f, 1.0f, gPositionScenery - 2.0f + x1, 0.3f, 0.99f, 0.0f, 0.5f, 0.99f, 0.5f, 0.99f, 0.99f, 0.0f, 0.99f);
		Render_Quad(TEXTURE_SCENERY, 1.0f, 1.0f, 1.0f, 0.0f, gPositionScenery - 1.5f + x1, -0.2f, 1.0f, gPositionScenery - 1.0f + x1, -0.2f, 1.0f, gPositionScenery - 1.0f + x1, 0.3f, 1.0f, gPositionScenery - 1.5f + x1, 0.3f, 0.99f, 0.0f, 0.0f, 0.99f, 0.0f, 0.99f, 0.5f, 0.0f, 0.5f);
	}
}

/***************************************************************************/

void Render_Tombstones()

{
	for (int x1=0;x1<6;x1=x1+1)
		Render_Quad(TEXTURE_TOMBSTONE, 1.0f, 1.0f, 1.0f, 0.0f, gPositionTombstones + gTombstone[x1].position, gTombstone[x1].height - 0.3f, 1.0f, gPositionTombstones + gTombstone[x1].position + 0.3f, gTombstone[x1].height - 0.3f, 1.0f, gPositionTombstones + gTombstone[x1].position + 0.3f, gTombstone[x1].height, 1.0f, gPositionTombstones + gTombstone[x1].position, gTombstone[x1].height, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.95f, 0.0f, 0.95f);
}

/***************************************************************************/